/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2026 i-net software GmbH, Berlin, Germany.
**/
package rdc;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;

import com.inet.report.BorderProperties;
import com.inet.report.Engine;
import com.inet.report.Picture;
import com.inet.report.RDC;

/**
 * This sample add a black picture to the Page Header section of a report at runtime
 */
public class AddBufferedImageToReport extends RDCSample {

    // Change the URL of the rpt file before running this example if the default location of the file "mainrep.rpt"
    // was changed. The default directory of this rpt file is: "samples/rdc".
    private static final String MAINREPORT = "samples/rdc/mainrep.rpt";

    /**
     * Adds an image to the page header section of a report.
     * @param exportFmt output format
     * @return engine the engine for the specified report
     */
    @Override
    public Engine createAndFillEngine( String exportFmt ) {
        try {
            // Create a new Engine
            Engine eng = new Engine( exportFmt );

            // Set the report file
            eng.setReportFile( MAINREPORT );

            //create an image
            int h = 32;
            int w = 64;
            BufferedImage im = new BufferedImage( w, h, BufferedImage.TYPE_INT_ARGB );
            Graphics g = im.getGraphics();
            g.setColor( Color.BLACK );
            g.fillRect( 0, 0, w, h );
            /* ... *///more image manipulation
            g.dispose();

            // Add the image data to the page header section
            Picture pic = eng.getArea( "PH" ).getSection( 0 ).addPicture( 2000, 0, w * 15, h * 15, im );
            pic.setTopLineStyle( BorderProperties.LINE_STYLE_SINGLE );
            pic.setBottomLineStyle( BorderProperties.LINE_STYLE_SINGLE );

            RDC.saveEngine( new File( "picture.xml" ), eng );
            return eng;

        } catch( Throwable e ) {
            e.printStackTrace();
            System.exit( 0 );
            return null;
        }
    }

    /**
     * Main method of the sample.
     * @param args no parameters used
     */
    public static void main( String[] args ) {
        new AddBufferedImageToReport().initUI();
    }
}
